<?php
/**
 * sql server Ӳ
 *
 * @author һ yandy@yanwee.com
 * @package 1.0
 * @version $Id$
 */

/**
 * Sql Server ݿdbQuery
 * @package Util
 */
class DbQueryForMssql {
	/**
	 * selectص¼
	 */
	const MAX_ROW_NUM = 100000;

	/**
	 * ݲѯ
	 * @var object $dataSet
	 */
	public $dataSet			= NULL ;

	/**
	 * Դ
	 * @var object $ds
	 */
	public $ds				= NULL ;

	/**
	 * ѯSQL
	 * @var string $sql
	 */
	public $sql				= '' ;
	
	public $transCnt 		= 0;
	
	/**
	 * ִвѯģʽֵΪ OCI_COMMIT_ON_SUCCESS  OCI_DEFAULT
	 * @var string $excuteMode
	 */
	public $executeMode	= OCI_COMMIT_ON_SUCCESS ;

	/**
	 * 캯
	 * @param object $ds ݿ
	 * @param string $sql ҪʼѯSQL
	 */
	function __construct($ds=NULL , $sql=NULL) {
		if (!$ds) {
			$this->error(DbException::DB_UNCONNECTED, 'ݿ⻹δӡ');
		} else {
			$this->ds = $ds;
			if ($sql) {
				$this->open($sql);
			}
		}
	}
	
	/**
	 * ͷռõڴ
	 * @param object $dataSet ҪͷԴĽ
	 * @access public
	 */
	public function close($dataSet=NULL) {
		if ($dataSet) {
			@mssql_free_statement($dataSet);
		} else {
			@mssql_free_statement($this->dataSet);
			$this->eof = false ;
			$this->recordCount = 0 ;
			$this->recNo = -1 ;
		}
	}
	function __destruct()
	{
		@mssql_free_result($this->dataSet);
		@mssql_free_statement($this->dataSet);
		@mssql_close($this->ds->connect);
	}	
	/**
	 * $passݿ,ؼֵ֮
	 * @param string $pass Ҫַܵ
	 * @return string
	 * @access public
	 */
	public function encodePassword($pass) {
		return md5($pass);
	}
	
	/**
	 * õϢʹ
	 * @param integer $queryResult ѯ
	 * @return array
	 * @access protected
	 */
	protected function errorInfo($queryResult = NULL) {
		$result['message'] = mssql_get_last_message();
		@mssql_select_db($this->ds->name,$this->ds->connect);
		/*if (!@mysql_select_db($this->ds->name)) {
			throw new DbException('ݿⲻ', DbException::DB_OPEN_FAILED);
		}*/
		$id = @mssql_query("select @@ERROR", $this->ds->connect);
		if (!$id) {
			return false;
		}
		$arr = mssql_fetch_array($id);
		@mssql_free_result($id);
		if (is_array($arr)) {
			$result['code'] = $arr[0];
	    } else {
			return $result['code'] = -1;
		}
		return $result;
	}
	
	/**
	 * Ϣ
	 * @param string $errorId ID
	 * @param string $errorMessage Ϣ
	 * @access protected
	 */
	protected function error($errorId, $errorMessage) {
		throw new DbException($errorMessage, $errorId);
	}
	
	/**
	 * ִSQL
	 * @param string $sql SQL
	 * @return object
	 * @param int $rowFrom ʼкţкŴ1ʼ
	 * @param int $rowTo кţֵΪ0ʾ
	 * @access public
	 * @see DbQuery::open
	 */
	public function execute($sql = '', $rowFrom = 0, $rowTo = self::MAX_ROW_NUM, $error = true) {
		//echo $this->ds->name;
		if ($rowTo != self::MAX_ROW_NUM) {
			$nrows = $rowTo - $rowFrom + 1; 
		}
		$offset = $rowFrom;
		if ($nrows > 0) {
			$nn = $nrows + $offset - 1;
			$sql = preg_replace('/(^\s*select\s+(distinctrow|distinct)?)/i', '\\1 top ' . $nn . ' ', $sql);
		}
		
		@mssql_select_db($this->ds->name,$this->ds->connect);
		/*if (!@mysql_select_db($this->ds->name)) {
			throw new DbException('ݿⲻ', DbException::DB_OPEN_FAILED);
		}*/
		$dataSet = @mssql_query($sql,  $this->ds->connect);
		//echo $sql .'<br/><br/><br/><br/>';
		if (!$dataSet && $error) {
			$sqlError = $this->errorInfo();
			$errorMessage = 'ִ[<b><font color="#FF0000">' . $sql 
					. '</font></b>]<br> <font color=#FF0000> ['
					. $sqlError['code'] . ']: '
					. $sqlError['message'] . '</font>' ;
			$this->error(DbException::DB_QUERY_ERROR, $errorMessage);
		}
	
		if ($offset) {
			$offset = $offset-1;//var_dump($dataSet);echo 'abc';
			$resultNum = mssql_num_rows($dataSet);
			if ($resultNum<$offset) {
				@mssql_data_seek($dataSet, $resultNum-1);
			} else {
				@mssql_data_seek($dataSet, $offset);
			}
		}
		return $dataSet;
	}
	
	/**
	 * ִSQL䣬浽$dataSet
	 * @param string $sql SQL
	 * @param int $rowFrom ʼкţкŴ1ʼ
	 * @param int $rowTo кţֵΪ0ʾ
	 * @return object
	 * @access public
	 * @see DbQuery::execute
	 */
	public function open($sql='', $rowFrom = 0, $rowTo = self::MAX_ROW_NUM) {
		$this->dataSet = $this->execute($sql, $rowFrom, $rowTo);
		$this->sql = $sql ;
		return $this->dataSet;
	}

	/**
	 * һеĸֵֵֶһ
	 * @param object $dataSet 
	 * @param integer $resultType ͣOCI_ASSOCOCI_NUM  OCI_BOTH
	 * @return array
	 */
	public function fetchRecord($dataSet=NULL, $resultType=MSSQL_BOTH) {
		$result = @mssql_fetch_array(($dataSet) ? $dataSet : $this->dataSet, $resultType);
		if (is_array($result)) {
			foreach ($result as $key => $value) {
				if (!is_numeric($key)) {
					$result[strtolower($key)] = $value;
				}
			}
		}
		return $result;
	}

	/**
	 * ȡֶ
	 * @param object $dataSet 
	 * @return integer
	 */
	public function getFieldCount($dataSet = NULL) {
	
		return mssql_num_fields(($dataSet) ? $dataSet : $this->dataSet);
	}
	
	/**
	 * ȡһ¼ؼ¼ţ˼¼β򷵻FALSE
	 * @return integer
	 * @access public
	 * @see getPrior()
	 */
	public function next() {
		return $this->fetchRecord();
	}
	
	/**
	 * õǰݿʱ䣬ʽΪyyyy-mm-dd hh:mm:ss
	 * @return string
	 * @access public
	 */
	public function getNow() {
		return $this->getValue('SELECT TO_CHAR(SYSDATE, \'YYYY-MM-DD HH24:MI:SS\') dateOfNow FROM DUAL');
	}
	
	/**
	 * SQLݱȡݣֻȡһ¼ֵ
	 * ¼ֻһֶΣֵֶֻ
	 * δҵ FALSE
	 *
	 * @param string $sql SQL
	 * @return array
	 * @access public
	 */
	public function getValue($sql = '',$dataFormat=MSSQL_BOTH) { 
		$dataSet = $this->execute($sql, 1, 1);

		if ($result = $this->fetchRecord($dataSet,$dataFormat)) {
			$fieldCount = $this->getFieldCount($dataSet);
			$idx = 0;
			if($dataFormat == MSSQL_ASSOC){//ʹMSSQL_ASSOC,ֻһʱ,Ҫ֪һе.
				$firstColumnInfo = mssql_fetch_field ($dataSet ,0 );
				$idx = $firstColumnInfo->name;//column name
			}
			$this->close($dataSet);//print_r($result);
			return ($fieldCount<=1) ? $result[$idx] : $result;
		} else {
			return false ;
		}
	}
	
	/**
	 * ȡIDԵֵ
	 *
	 * @return int
	 * @access public
	 */	
	public function getInsertId() {
		return $this->getValue('select @@identity');
	}
	
	/**
	 * ȡ
	 * @param $seq 
	 * @return int
	 * @access public
	 */	
	public function getSeq($seq = '') { 
		$this->execute('BEGIN TRANSACTION adodbseq');
		$ok = $this->execute("update $seq with (tablock,holdlock) set id = id + 1", 0, self::MAX_ROW_NUM, false);
		if (!$ok) {
			$this->execute("create table $seq (id float(53))");
			$ok = $this->execute("insert into $seq with (tablock,holdlock) values(1)", 0, self::MAX_ROW_NUM, false);
			if (!$ok) {
				$this->execute('ROLLBACK TRANSACTION adodbseq');
				return false;
			}
			$this->execute('COMMIT TRANSACTION adodbseq'); 
			return 1;
		}
		$num = $this->getValue("select id from $seq");
		$this->execute('COMMIT TRANSACTION adodbseq'); 
		return $num;
	}
	/**
	 * Ƿڣtrue
	 * @param string $tableName Ҫѯı
	 * @return bool
	 * @access public
	 */
	public function tableIsExists($tableName) {
		return false;
	}
	
	/**
	 * ʼ
	 * @access public
	 */
	public function begin() {
		$this->transCnt += 1;
	   	$this->execute('BEGIN TRAN');
	   	return true;
	}
	
	/**
	 * ύ
	 * @access public
	 */
	public function commit() {
		if ($this->transCnt) {
			$this->transCnt -= 1;
		}
		$this->execute('COMMIT TRAN');
		return true;
	}
	
	/**
	 * ع
	 * @access public
	 */
	public function rollback() {
		if ($this->transCnt){
			$this->transCnt -= 1;
		}
		$this->execute('ROLLBACK TRAN');
		return true;
	}
	
	/**
	 * һ¼
	 * @param string $tableName 
	 * @param array $fieldArray ֶ
	 * @param string $whereForUnique Ψһ
	 * @return int
	 * @access public
	 */
	public function insert($tableName, $fieldArray, $whereForUnique = NULL) {
		if (!$tableName || !$fieldArray || !is_array($fieldArray)) {
			throw new Exception(' $tableName  $fieldArray ֵϷ');
		}
		if ($whereForUnique) {
			$where = ' WHERE ' . $whereForUnique;
			$isExisted = $this->getValue('SELECT COUNT(*) FROM ' . $tableName . $where);
			if ($isExisted) {
				throw new DbException('¼Ѿڣ', DbException::DB_RECORD_IS_EXISTED);
			}
		}
		$fieldNameList = array();
		$fieldValueList = array();
		foreach ($fieldArray as $fieldName => $fieldValue) {
			if (!is_int($fieldName)) {
				$fieldNameList[] = $fieldName;
				$fieldValueList[] = '\'' . $fieldValue . '\'';
			}
		}
		$fieldName = implode(',', $fieldNameList);
		$fieldValue = implode(',', $fieldValueList);
		$sql = 'INSERT INTO ' . $tableName . '('
					. $fieldName . ') VALUES (' . $fieldValue . ')';
		//return $sql;
		return $this->execute($sql);
	}
	
	/**
	 * һ¼
	 * @param string $tableName 
	 * @param array $fieldArray ֶ
	 * @param string $whereForUpdate ѯ
	 * @param string $whereForUnique Ψһ
	 * @return int
	 * @access public
	 */
	public function update($tableName, $fieldArray, $whereForUpdate=NULL, $whereForUnique=NULL) {
		if (!$tableName || !$fieldArray || !is_array($fieldArray)) {
			throw new Exception(' $tableName  $fieldArray ֵϷ');
		}
		if ($whereForUnique) {
			$where = ' WHERE ' . $whereForUnique;
			$isExisted = $this->getValue('SELECT COUNT(*) FROM ' . $tableName . $where);
			if ($isExisted) {
				throw new DbException('¼Ѿڣ', DbException::DB_RECORD_IS_EXISTED);
			}
		}
		$fieldNameValueList = array();
		foreach ($fieldArray as $fieldName => $fieldValue) {
			if (!is_int($fieldName)) {
				$fieldNameValueList[] = $fieldName . '=\'' . $fieldValue . '\'';
			}
		}
		$fieldNameValue = implode(',', $fieldNameValueList);
		if ($whereForUpdate) {
			$whereForUpdate = ' WHERE ' . $whereForUpdate;
		}
		$sql = 'UPDATE ' . $tableName 
				. ' SET ' . $fieldNameValue . $whereForUpdate;
		return $this->execute($sql);
		//return $sql;
	}
	
	/**
	 * ѡһ¼
	 * @param string $sql sql
	 * @param string $dataFormat ݸʽ, ֵ"array","hashmap","hashmap_str","dataset"
	 * @param int $rowFrom ʼкţкŴ1ʼ
	 * @param int $rowTo кţֵΪ0ʾ
	 * @result array
	 * @access public
	 */
	public function select($sql, $dataFormat = 'array', $rowFrom = 0, $rowTo = self::MAX_ROW_NUM) {
		$dataSet = $this->execute($sql, $rowFrom, $rowTo);
		switch ($dataFormat) {
		case 'array': //
			$result = array();
			$isMultiField = ($this->getFieldCount($dataSet) > 1);
			$i = 0;
			while ($data = $this->fetchRecord($dataSet)) {
				$result[$i] = ($isMultiField) ? $data : $data[0];
				$i++;
			}
			$this->close($dataSet);
			break;

		case 'arrayassoc': //,BUG,ҪΪ!ֻһʱ
			$result = array();
			$isMultiField = ($this->getFieldCount($dataSet) > 1);
			$i = 0;
			while ($data = $this->fetchRecord($dataSet,MSSQL_ASSOC)) {
				$idx = 0;
				if(!$isMultiField){//ֻһеĻ
					if($dataFormat == MSSQL_ASSOC){//MSSQL_ASSOC,ֻһʱ,Ҫ֪һе.
					$firstColumnInfo = mssql_fetch_field ($dataSet ,0 );
					$idx = $firstColumnInfo->name;//column name
					}
				}
				$result[$i] = ($isMultiField) ? $data : $data[$idx];
				$i++;
			}
			$this->close($dataSet);
			break;
			
		case 'hashmap': //ɢб
			$result = array();
			while ($data = $this->fetchRecord($dataSet)) {
				$result[ $data[0] ] = $data[1];
			}
			$this->close($dataSet);
			break;

		case 'hashmap_str': //ɢбַ
			$result = array();
			while ($data = $this->fetchRecord($dataSet, OCI_NUM)) {
				$result[] = $data[0] . '=' . $data[1];
			}
			$result = implode('|', $result);
			$this->close($dataSet);
			break;

		default: //dataset ݼݸʽΪݼʱselectĹexecuteͬ
			$result = $dataSet;
		}
		return $result;
	}
	
	/**
	 * ֵ
	 * @param string $tableName 
	 * @param string $idField ֶ
	 * @param string $where ѯ
	 * @return int
	 * @access public
	 */
	public function getMax($tableName, $idField, $where = NULL) {
		$where = ($where) ? (' WHERE ' . $where) : '';
		return $this->getValue('SELECT MAX(' . $idField . ') FROM ' . $tableName . $where);
	}
}
?>
